/**
* \file: gst_viv_buffer.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* Vivante YUV texture buffer for Gstreamer framework.
* This buffer is used to pass data between the gstreamer and VIVANTE
* graphics hardware
*
* \component: gst_viv_demo
*
* \author: Michael Methner ADITG/SW1 mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2012 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
***********************************************************************/



#include "gst_egl_buffer.h"

/* PRQA: Lint Message 826: deactivation because casting mechanism of GObject throws the finding */
/*lint -e826*/

GST_DEBUG_CATEGORY_STATIC( gst_egl_buffer_debug);
#define GST_CAT_DEFAULT gst_egl_buffer_debug

/* PRQA: Lint Message 19, 123, 144, 751, 160: deactivation because macro is related to GStreamer framework */
/*lint -e19 -e123 -e144 -e751 -e160 */
GST_BOILERPLATE(GstEglBuffer, gst_egl_buffer, GstBuffer, GST_TYPE_BUFFER);
/*lint +e19 +e123 +e144 +e751 +e160 */


static GstBufferClass *egl_buffer_parent_class = NULL;



/**
* \func gst_viv_buffer_finalize
* This function is called when the recount drops to 0 by the gstreamer
* framework. The function calls the finalize method of the buffer object
* if set.
*
* \param buffer "This" pointer
*
*/
static void
gst_egl_buffer_finalize(GstEglBuffer * buffer)
{
  gboolean recycled = FALSE;

  g_return_if_fail(buffer != NULL);

  if (NULL != buffer->finalize)
    {
      recycled = (buffer->finalize)(buffer, buffer->parent);
    }

  if (!recycled)
    {
      GST_DEBUG("Buffer not recycled: %p", buffer);
      if (buffer->parent)
        {
          gst_object_unref(buffer->parent);
          buffer->parent = NULL;

        }
      if(GST_BUFFER_CAPS(buffer))
          {
          gst_caps_unref(GST_BUFFER_CAPS(buffer));
          GST_BUFFER_CAPS(buffer) = NULL;
          }
    }
  return;
}



/**
* \func gst_viv_buffer_base_init
* Initialize the class
*
* \param gclass Pointer to GstVivBufferClass
* *
*/
static void
gst_egl_buffer_base_init(gpointer gclass)
{
  /* this function is intentionally blank */
  /* do not delete, it used by the get_type function */
  gclass = gclass;
}


/**
* \func gst_viv_buffer_init
* Initialize the buffer
*
* \param buffer "This" pointer
* \param klass Pointer to GstVivBufferClass
* *
*/
static void
gst_egl_buffer_init(GstEglBuffer * buffer, GstEglBufferClass * klass)
{
  klass = klass;

  GST_BUFFER(buffer)->data = NULL;
  buffer->parent = NULL;
  buffer->finalize = NULL;
  buffer->window_surface = 0;
  buffer->native_pixmap = 0;
}


/**
* \func gst_viv_buffer_class_init
* Initialize the buffer class
*
* \param klass Pointer to GstVivBufferClass
* *
*/
static void
gst_egl_buffer_class_init(GstEglBufferClass * klass)
{
  GST_DEBUG_CATEGORY_INIT(gst_egl_buffer_debug, "gst_egl_buffer", 0,
      "GstBuffer with EGL Surface");

  GstMiniObjectClass *mini_object_class = GST_MINI_OBJECT_CLASS(klass);

  egl_buffer_parent_class = g_type_class_peek_parent(klass);

  mini_object_class->finalize
      = (GstMiniObjectFinalizeFunction) gst_egl_buffer_finalize;

  parent_class = g_type_class_peek_parent(klass);
}


/*lint +e826*/
